# AI_Alignment Lean4 proofs

This folder contains Lean4 + mathlib formalisation artifacts for the LP–PM–ERT framework.

## Build

```bash
source ~/.elan/env
cd /home/peter/Documents/thoughts/AI_Alignment/lean
lake build
```

## What is currently proven

- `AIAlignment/LambdaDynamics.lean`
  - Basic invariants of the multiplicative renormalisation λ-update:
    - if λᵢ ≥ 0 and Sᵢ ≥ 0 and denom > 0, then λᵢ' ≥ 0
    - if denom ≠ 0, then ∑ λ' = 1

- `AIAlignment/PenaltyERT.lean`
  - For T(k,x) = 1 - exp(-k*x) with k>0 and x≥0:
    - 0 ≤ T(k,x) ≤ 1
  - For calibration loss Lcal = (T - hatT)^2 with hatT ∈ [0,1]:
    - Lcal ≥ 0
    - Lcal ≤ 1

- `AIAlignment/PenaltyERT_MR.lean`
  - Defines full ERT penalty Lert = Lcal + β*MR (MR abstract).
  - Proves:
    - Lert ≥ 0 when β ≥ 0 and MR ≥ 0
    - Lert ≤ 1 + β*M when (i) Lcal ≤ 1 and (ii) MR ≤ M and β ≥ 0

These are structural “well-formedness” guarantees (not convergence proofs).
